<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <?php echo $__env->yieldContent('extra-meta'); ?>

    <title>GAS V1</title>
        <!-- Tell the browser to be responsive to screen width -->
    <link rel="icon" href="<?php echo e(asset('images/pcsoft.png')); ?>" type="image/png">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="<?php echo e(asset('plugins/fontawesome-free/css/all.min.css')); ?>">
    <!-- Ionicons -->
    <link rel="stylesheet" href="<?php echo e(asset('css/ionicons.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/main_style.css')); ?>" type="text/css">
    <link rel="stylesheet" href="<?php echo e(asset('css/sweetalert2.css')); ?>" type="text/css">
    <!-- JQVMap -->
    <!-- Theme style -->
    <link rel="stylesheet" href="<?php echo e(asset('dist/css/adminlte.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('dist/css/adminlte.core.min.css')); ?>">
    <!-- overlayScrollbars -->
    <link rel="stylesheet" href="<?php echo e(asset('plugins/overlayScrollbars/css/OverlayScrollbars.min.css')); ?>">
    <!-- Google Font: Source Sans Pro
    <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">-->

    <link rel="stylesheet" href="<?php echo e(asset('dist/css/bootstrap.min.css')); ?>" />


    <link rel="stylesheet" href="<?php echo e(asset('dist/css/jquery.dataTables.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('dist/css/dataTables.bootstrap4.min.css')); ?>" />

</head>
<body class="hold-transition sidebar-mini layout-fixed layout-navbar-fixed layout-footer-fixed">
<div class="wrapper">

<!-- Navbar -->
<nav class="main-header navbar navbar-expand navbar-white navbar-light">
    <!-- Left navbar links -->
    <ul class="navbar-nav" style="background-color: #fff">
        <li class="nav-item">
            <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i class="fas fa-bars"></i></a>
        </li>
    </ul>

    <?php
    $defaultLocale = app()->getLocale();
    ?>

    <div class="container" style="margin-left: 80%">
        <div class="row" style="justify-content: space-around; align-items:center">
            <div class="col-md-3">
                <i class="fa fa-globe"></i>
            </div>
            <div>
                <select class="form-control" onchange="window.location.href=this.value" style="border: none">
                    <?php $__currentLoopData = LaravelLocalization::getSupportedLocales(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $localeCode => $properties): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e(LaravelLocalization::getLocalizedURL($localeCode, null, [], true)); ?>"
                            <?php echo e($localeCode === $defaultLocale ? 'selected' : ''); ?>>
                            <?php echo e($properties['native']); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
        </div>
    </div>
</nav>


<!-- /.navbar -->

<!-- Main Sidebar Container -->
<aside class="main-sidebar sidebar-dark-primary elevation-04">
    <!-- Brand Logo -->
    <a href="<?php echo e(route('app.home')); ?>" class="brand-link">
        <img src="/images/logo.png" alt="" class="brand-image img-circle elevation-3"
             style="opacity: .8">
        <span class="brand-text font-weight-light"><?php echo e(\Illuminate\Support\Facades\Auth::user()->centre_id); ?></span>
    </a>

    <!-- Sidebar -->
    <div class="sidebar">
        <!-- Sidebar user panel (optional) -->
        <div class="user-panel mt-3 pb-3 mb-3 d-flex">
            <div class="image">
                <img src="dist/img/user2-160x160.jpg" class="img-circle elevation-2" alt="">
            </div>
            <div class="info">
                <a href="<?php echo e(route('user.moncompte',\Illuminate\Support\Facades\Auth::user()->id)); ?>"><?php echo e(\Illuminate\Support\Facades\Auth::user()->name); ?></a>
            </div>
        </div>

        <!-- Sidebar Menu -->
        <?php echo $__env->make('sweetalert::alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <nav class="mt-2">
            <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="false">
                <!-- Add icons to the links using the .nav-icon class
                     with font-awesome or any other icon font library -->
                <li class="info">
                    <a href="#" class="nav-link active" style="background-color: #27a5de;">
                        <i class="nav-icon fas fa-tachometer-alt"></i>
                        <p>
                        <?php echo e(__('messages.MENU GENERAL')); ?>

                        </p>
                    </a>
                </li><br>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-action', ['menu','donnee'])): ?>
                <li class="nav-item has-treeview">
                    <a href="<?php echo e(route('cat.index')); ?>" class="nav-link">
                        <i class="nav-icon fas fa-copy ml-2"></i>
                        <p>
                        <?php echo e(__('messages.DONNEES DE BASE')); ?>

                        </p>
                    </a>
                </li>
                <?php endif; ?>
                <li class="nav-item has-treeview menu-open">
                    <a href="#" class="nav-link active" style="background-color: #08588d;">
                        <i class="nav-icon fas fa-tachometer-alt"></i>
                        <p>
                        <?php echo e(__('messages.GESTION DE STOCK')); ?>

                        </p>
                    </a>
                </li>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-action', ['menu','stock'])): ?>
                <li class="nav-item has-treeview">
                    <a href="#" class="nav-link">
                        <i class="nav-icon fab fa-buy-n-large ml-2"></i>
                        <?php echo e(__('messages.FORMATION SANITAIRE')); ?>

                    </a>
                    <ul class="nav nav-treeview">
                        <li class="nav-item ml-4">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-action', ['commande','lister'])): ?>
                            <a href="<?php echo e(route('cmde.index')); ?>" class="nav-link">
                                <i class="fas fa-shopping-cart nav-icon"></i>
                                <p><?php echo e(__('messages.Gestion des commandes')); ?></p>
                            </a>
                            <?php endif; ?>
                        </li>
                        <li class="nav-item ml-4">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-action', ['reception','lister'])): ?>
                            <a href="<?php echo e(route('rec.index')); ?>" class="nav-link">
                                <i class="fas fa-plus nav-icon"></i>
                                <p><?php echo e(__('messages.Reception commandes')); ?></p>
                            </a>
                            <?php endif; ?>
                        </li>
            
                        <li class="nav-item ml-4">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-action', ['transfert','lister'])): ?>
                            <a href="<?php echo e(route('tr.index')); ?>" class="nav-link">
                                <i class="fas fa-backspace nav-icon"></i>
                                <p><?php echo e(__('messages.Transfert de produit')); ?></p>
                            </a>
                            <?php endif; ?>
                        </li>
                        <li class="nav-item ml-4">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-action', ['confection_kit','lister'])): ?>
                            <a href="#" class="nav-link">
                                <i class="fas fa-backspace nav-icon"></i>
                                <p><?php echo e(__('messages.Confection des Kits')); ?></p>
                            </a>
                            <?php endif; ?>
                        </li>
                        <li class="nav-item ml-4">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-action', ['correction','lister'])): ?>
                            <a href="<?php echo e(route('cs.index')); ?>" class="nav-link">
                                <i class="fas fa-store nav-icon"></i>
                                <p><?php echo e(__('messages.Corection du stock')); ?></p>
                            </a>
                            <?php endif; ?>
                        </li>

                        <li class="nav-item ml-4">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-action', ['stock','lister'])): ?>
                            <a href="<?php echo e(route('inv.etatglobal')); ?>" class="nav-link">
                                <i class="fas fa-home nav-icon"></i>
                                <p><?php echo e(__('messages.Etat du stock')); ?></p>
                            </a>
                            <?php endif; ?>
                        </li>
                        <li class="nav-item ml-4">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-action', ['stock','lister'])): ?>
                            <a href="<?php echo e(route('inv.invglobal')); ?>" class="nav-link">
                                <i class="fas fa-store  nav-icon"></i>
                                <p><?php echo e(__('messages.Inventaires')); ?></p>
                            </a>
                            <?php endif; ?>
                        </li>
                    </ul>
                </li>
                <?php endif; ?>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-action', ['menu','dps'])): ?>
                <li class="nav-item has-treeview">
                    <a href="#" class="nav-link">
                        <i class="nav-icon fas fa-copy ml-2"></i>
                        <p>
                        <?php echo e(__('messages.DPS')); ?>

                        </p>
                    </a>
                    <ul class="nav nav-treeview">
                        <li class="nav-item ml-4">
                            <a href="<?php echo e(route('val.index')); ?>" class="nav-link">
                                <i class="fas fa-copy nav-icon"></i>
                                <p><?php echo e(__('messages.Valider une commande')); ?></p>
                            </a>
                        </li>
                        <li class="nav-item ml-4">
                            <a href="<?php echo e(route('eg.stockglobal')); ?>" class="nav-link">
                                <i class="fas fa-home nav-icon"></i>
                                <p><?php echo e(__('messages.Etat du stock')); ?></p>
                            </a>
                        </li>
                        <li class="nav-item ml-4">
                            <a href="<?php echo e(route('invsi.invglobal')); ?>" class="nav-link">
                                <i class="fas fa-store  nav-icon"></i>
                                <p>Etat des recettes</p>
                            </a>
                        </li>
                        <li class="nav-item ml-4">
                            <a href="<?php echo e(route('invsi.invglobal')); ?>" class="nav-link">
                                <i class="fas fa-store  nav-icon"></i>
                                <p><?php echo e(__('messages.Inventaires')); ?></p>
                            </a>
                        </li>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-action', ['menu','userdps'])): ?>
                        <li class="nav-item ml-4">
                            <a href="<?php echo e(route('user.userdps')); ?>" class="nav-link">
                                <i class="fas fa-home nav-icon"></i>
                                <p><?php echo e(__('messages.Utilisateur DPS')); ?></p>
                            </a>
                        </li>
                        <?php endif; ?>
                    </ul>    
                </li>
                <?php endif; ?>
                
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-action', ['menu','si'])): ?>
                <li class="nav-item has-treeview">
                    <a href="#" class="nav-link">
                        <i class="nav-icon fab fa-buy-n-large ml-2"></i>
                        <p>
                        <?php echo e(__('messages.SANTE INTEGREE')); ?>

                        </p>
                    </a>
                    <ul class="nav nav-treeview">
                        <li class="nav-item ml-4">
                            <a href="<?php echo e(route('recsi.index')); ?>" class="nav-link">
                                <i class="fas fa-plus nav-icon"></i>
                                <p><?php echo e(__('messages.Reception Grossiste')); ?></p>
                            </a>
                        </li>
                        <li class="nav-item ml-4">
                            <a href="<?php echo e(route('trsi.index')); ?>" class="nav-link">
                                <i class="fas fa-plus nav-icon"></i>
                                <p><?php echo e(__('messages.Transfert vers FS')); ?></p>
                            </a>
                        </li>
                        <li class="nav-item ml-4">
                            <a href="<?php echo e(route('cmde.histo')); ?>" class="nav-link">
                                <i class="fas fa-backspace nav-icon"></i>
                                <p><?php echo e(__('messages.Suivi des commandes')); ?></p>
                            </a>
                        </li>

                        <li class="nav-item ml-4">
                            <a href="<?php echo e(route('eg.stockglobal')); ?>" class="nav-link">
                                <i class="fas fa-home nav-icon"></i>
                                <p><?php echo e(__('messages.Etat du stock')); ?></p>
                            </a>
                        </li>
                        <li class="nav-item ml-4">
                            <a href="<?php echo e(route('invsi.invglobal')); ?>" class="nav-link">
                                <i class="fas fa-store  nav-icon"></i>
                                <p><?php echo e(__('messages.Inventaires')); ?></p>
                            </a>
                        </li>
                        <li class="nav-item ml-4">
                            <a href="<?php echo e(route('eg.etatcaissesi')); ?>" class="nav-link">
                                <i class="fas fa-store  nav-icon"></i>
                                <p><?php echo e(__('messages.Etat des recettes')); ?></p>
                            </a>
                        </li>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-action', ['menu','usersi'])): ?>
                        <li class="nav-item ml-4">
                            <a href="<?php echo e(route('user.usersi')); ?>" class="nav-link">
                                <i class="fas fa-backspace nav-icon"></i>
                                <p><?php echo e(__('messages.Utilisateur SI')); ?></p>
                            </a>
                        </li>
                        <?php endif; ?>
                    </ul>
                </li>
                <?php endif; ?>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-action', ['menu','caisse'])): ?>
                <li class="nav-item has-treeview">
                    <a href="#" class="nav-link" style="background-color: #27a5de;">
                        <i class="nav-icon fas fa-copy"></i>
                        <p>
                        <?php echo e(__('messages.CAISSE/COMPTABILITE')); ?>

                        </p>
                    </a>
                    <ul class="nav nav-treeview">
                        <li class="nav-item ml-4">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-action', ['vente','lister'])): ?>
                            <a href="<?php echo e(route('vente.index')); ?>" class="nav-link">
                                <i class="fas fa-box nav-icon"></i>
                                <p><?php echo e(__('messages.Fiche de Vente')); ?></p>
                            </a>
                            <?php endif; ?>
                        </li>
                        <li class="nav-item ml-4">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-action', ['vente','encaisser'])): ?>
                            <a href="<?php echo e(route('vente.index')); ?>" class="nav-link">
                                <i class="nav-icon fas fa-oil-can ml-2"></i>
                                <?php echo e(__('messages.PHARMACIE / VENTE')); ?>

                            </a>
                            <?php endif; ?>
                        </li>
                        <li class="nav-item ml-4">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-action', ['vente','etat_recette'])): ?>
                            <a href="<?php echo e(route('vente.etatcaisse')); ?>" class="nav-link">
                                <i class="fas fa-calculator nav-icon"></i>
                                <p><?php echo e(__('messages.Etat des recettes')); ?></p>
                            </a>
                            <?php endif; ?>
                        </li>
                        <li class="nav-item ml-4">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-action', ['vente','etat_assurance'])): ?>
                            <a href="<?php echo e(route('vente.etatassurance')); ?>" class="nav-link">
                                <i class="fas fa-asterisk nav-icon"></i>
                                <p><?php echo e(__('messages.Facturer les assurances')); ?></p>
                            </a>
                            <?php endif; ?>
                        </li>
                        <li class="nav-item ml-4">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-action', ['operation','creer'])): ?>
                            <a href="<?php echo e(route('op.index')); ?>" class="nav-link">
                                <i class="fas fa-credit-card nav-icon"></i>
                                <p><?php echo e(__('messages.Operation Bancaire')); ?></p>
                            </a>
                            <?php endif; ?>
                        </li>
                    </ul>
                </li>
                <?php endif; ?>
                <li class="nav-item has-treeview menu-open">
                    <a href="#" class="nav-link" style="background-color: #d1d73f;">
                        <i class="nav-icon fas fa-digital-tachograph"></i>
                        <p>
                            <?php echo e(__('messages.ADMINISTRATION')); ?>

                        </p>
                    </a>
                </li>
                <li class="nav-item has-treeview">
                    <!-- <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-action', ['user','lister'])): ?>-->
                    <a href="<?php echo e(route('user.index')); ?>" class="nav-link">
                        <i class="nav-icon fa fa-file-invoice"></i>
                        <p>
                            <?php echo e(__('messages.ESPACE ADMINISTRATION')); ?>

                        </p>
                    </a>
                    <!--<?php endif; ?>-->
                </li>
                <li class="nav-item">
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-action', ['utilisateur','lister'])): ?>
                    <a href="<?php echo e(route('user.index')); ?>" class="nav-link">
                        <i class="nav-icon fa fa-file-invoice"></i>
                        <p class="text"><?php echo e(__('messages.ESPACE ADMINISTRATION')); ?></p>
                    </a>
                <?php endif; ?>    
                </li>
                <li class="nav-item">
                    <a href="#" class="nav-link">
                        <i class="nav-icon fa fa-user"></i>
                        <p class="text"><?php echo e(__('messages.MON COMPTE')); ?></p>
                    </a>
                </li>
                <li class="nav-item has-treeview menu-open" style="background-color: #e92676">
                    <form action="<?php echo e(route('logout')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('POSt'); ?>
                        <button type="submit" class="btn"><i class="nav-icon fas fa-sign-out-alt"></i>
                        <span class="text"><?php echo e(__('messages.Deconnexion')); ?></span>
                        </button>
                    </form>
                </li>
            </ul>
        </nav>
        <!-- /.sidebar-menu -->
    </div>
    <!-- /.sidebar -->
</aside>

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper mb-7">
    <!-- Main content -->
    <?php if(session('success')): ?>
        <div class="alert alert-success col-8 ml-5">
            <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>

    <?php if(count($errors)>0): ?>
        <div class="alert alert-danger col-8 ml-5">
            <ul class="mt-0 mb-0">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>
    <?php echo $__env->yieldContent('content'); ?>
    <?php echo $__env->make('sweetalert::alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<!-- /.content -->
</div>
<!-- /.content-wrapper -->
<footer class="main-footer col-12 col-sm-12 col-md-12 mt">
    <strong>Copyright  <?php echo e(__('messages.SANTE INTEGREE')); ?> &copy; 2023 GAS V1.</strong>
    <?php echo e(__('messages.Tous droits reserves')); ?>

    <div class="float-right d-none d-sm-inline-block">
        <b>Version</b> 5.0.1
    </div>
</footer>
</div>
<!-- ./wrapper -->

<!-- jQuery -->
<script src="<?php echo e(asset('plugins/jquery/jquery.min.js')); ?>"></script>
<!-- jQuery UI 1.11.4 -->

<!-- AdminLTE App -->
<script src="<?php echo e(asset('dist/js/adminlte.js')); ?>"></script>
<!-- AdminLTE dashboard demo (This is only for demo purposes) -->
<script src="<?php echo e(asset('dist/js/pages/dashboard.js')); ?>"></script>
<!-- AdminLTE for demo purposes -->

<script src="<?php echo e(asset('dist/js/jquery.validate.js')); ?>"></script>
<script src="<?php echo e(asset('dist/js/jquery.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(asset('dist/js/dataTables.bootstrap4.min.js')); ?>"></script>
<script src="<?php echo e(asset('dist/js/bootstrap.min.js')); ?>"></script>
<script src="<?php echo e(asset('dist/js/bootstrap-datepicker.js')); ?>"></script>
<script src="<?php echo e(asset('dist/js/sum().js')); ?>"></script>
<script src="<?php echo e(asset('js/sweetalert.js')); ?>"></script>
<script src="<?php echo e(asset('js/sweetalert2.js')); ?>"></script>


</body>
<?php echo $__env->yieldContent('extra-js'); ?>
</html>
<?php /**PATH C:\APP\gas1\resources\views/layouts/adminlayout.blade.php ENDPATH**/ ?>